define(['angular', 'angularSnap', 'accessibleTimePickerServices', 'TimeControls'], function (angular) {
	'use strict';

	var app = angular.module('va-tool-set', [
		'ngSanitize',
		'ngTouch',
		'ui.router',
		'ui.bootstrap',
		'ui.utils',
		'snap',
		'unsavedChanges',
		'delayManager',
		'focusManager',
		'accessibleDatePickerServices',
		'accessibleTimePickerServices',
		'DateControls',
		'TimeControls',
        'highcharts-ng',
		'AccessibleAccordion'
	]);

	app.config(function ($controllerProvider, $provide, $httpProvider, $logProvider) {
		$httpProvider.defaults.useXDomain = true;
		delete $httpProvider.defaults.headers.common['X-Requested-With'];
		$httpProvider.interceptors.push('httpInterceptor');
		$httpProvider.interceptors.push('busyHttpInterceptor');

		// var ENV_MODE = 'production';

		// setLoggingPolicy();

		function setLoggingPolicy() {
			if (ENV_MODE === 'production') {
				disableLogging();
			}
		}

		function disableLogging() {
			$logProvider.debugEnabled(false);
			$provide.decorator('$log', ['$delegate', function ($delegate) {
				$delegate.info = angular.noop;
				$delegate.warn = angular.noop;
				$delegate.error = angular.noop;
				return $delegate;
			}]);
		}
	});

	app.directive('scrollContainer', function ($window, $timeout) {
		return function (scope, element) {
			angular.element($window).bind("resize", function(){
				$timeout(function(){
					element.height("calc(100% - " + (angular.element('.main-header').height() + angular.element('.main-footer').height() + 20) + "px)");
				});
			});
			scope.$watch(function(){
				return $window.innerHeight + $window.innerWidth;
			}, function(){
				angular.element($window).trigger("resize");
			})
		};
	});

	return app;
});